/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.publisher.udf.UDFXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskWizardDialog;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PADataFieldImportWizard
extends VWTaskWizardDialog {
    PADataFieldsNode m_node = null;
    ImportWizardPanel m_panel = null;

    public PADataFieldImportWizard(PADataFieldsNode node) {
        super((Frame)VWTaskCore.getInstance().getMainFrame(), VWResource.ImportDataFields, VWStringUtils.stringToDimension(VWResource.ImportDataFieldsDialogDim));
        this.m_node = node;
        this.setConfirmOnCancel(false);
        this.setButtonVisible(0, false);
        this.setButtonVisible(1, false);
        this.setButtonText(2, VWResource.Import);
        this.m_panel = new ImportWizardPanel();
        this.addWizardPanel(this.m_panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws Exception {
        block6: {
            try {
                this.m_node.getPANode().importDataFields(this.m_panel.getImportFile());
            }
            catch (VWException ex) {
                if (ex.getKey() != null && ex.getKey().startsWith("pa.publisher.udf.UDFAdmin.OLAPException")) {
                    this.m_node.getPANode().displayWarning(ex);
                    break block6;
                }
                throw ex;
            }
            finally {
                this.m_node.refresh();
            }
        }
    }

    public class ImportWizardPanel
    extends JPanel
    implements IVWTaskWizardPanel,
    IVWTaskWizardControl,
    KeyListener,
    ActionListener {
        JButton browseButton = null;
        JTextField importFileTxt = null;

        public ImportWizardPanel() {
            this.initLayout();
        }

        public String getImportFile() {
            return this.importFileTxt.getText().trim();
        }

        public void performValidation() throws Exception {
        }

        public String getInstructions() {
            return VWResource.ImportDataFieldsInstructions;
        }

        public String getHelpPath() {
            return VWHelp.Help_Process_TaskManager + "pa_data_fields_import.htm";
        }

        public void refresh() {
        }

        public boolean allowButtonToBeEnabled(int button) {
            if (button == 2) {
                return !this.importFileTxt.getText().trim().equals("");
            }
            return false;
        }

        public void keyReleased(KeyEvent evt) {
            PADataFieldImportWizard.this.updateButtonState();
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.browseButton) {
                FileDialog fileDialog = new FileDialog(VWTaskCore.getInstance().getMainFrame());
                fileDialog.setMode(0);
                fileDialog.setTitle(VWResource.Import);
                fileDialog.setFile("*.xml");
                fileDialog.show();
                String filePath = fileDialog.getDirectory();
                String fileName = fileDialog.getFile();
                if (filePath != null && fileName != null) {
                    try {
                        int region = UDFXMLHandler.parseIsolatedRegion((String)(filePath + fileName));
                        this.importFileTxt.setText(filePath + fileName);
                        PADataFieldImportWizard.this.updateButtonState();
                    }
                    catch (Exception ex) {
                        VWTaskCore.getInstance().displayError((Throwable)ex, false);
                    }
                }
            }
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 0);
            this.add((Component)new JLabel(VWResource.ImportFile + ":"), c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 0);
            this.importFileTxt = new JTextField();
            this.importFileTxt.setEditable(false);
            this.importFileTxt.addKeyListener(this);
            this.add((Component)this.importFileTxt, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 10);
            this.browseButton = new JButton(VWResource.Browse);
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 3;
            c.insets = new Insets(0, 0, 0, 0);
            this.add(Box.createHorizontalStrut(1), c);
        }

        public boolean skipThisPanel() {
            return false;
        }
    }
}

